package com.vf106.tools.adapter;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.vf106.tools.R;
import com.vf106.tools.bean.BaseBean;

import java.util.List;

public class TestAdapter extends RecyclerView.Adapter<TestAdapter.ViewHolder> {
    public List<BaseBean> list;

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private final RelativeLayout rlItem;
        View ladderCodeView;
        private final TextView tvName;

        public ViewHolder(@NonNull View view) {
            super(view);
            ladderCodeView = view;
            tvName = view.findViewById(R.id.tv_name);
            rlItem = view.findViewById(R.id.rl_item);
        }
    }

    public TestAdapter(List<BaseBean> deviceList) {
        this.list = deviceList;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_test_layout, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        viewHolder.rlItem.setOnClickListener(view1 -> mOnItemClickListener.onItemClick(view1, viewHolder.getAdapterPosition()));
        return viewHolder;
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        BaseBean bean = list.get(position);
        holder.tvName.setText((position + 1) + ". " + bean.getName());
        if (bean.getState() == 0) {
            holder.rlItem.setBackgroundColor(Color.WHITE);
        } else if (bean.getState() == 1) {
            holder.rlItem.setBackgroundColor(Color.GREEN);
        } else if (bean.getState() == 2) {
            holder.rlItem.setBackgroundColor(Color.RED);
        }
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    public interface OnItemClickListener {
        void onItemClick(View v, int position);
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }
}
